//by DESPI, 2019, MIDI DISPENCER, v3.1
//static-waves.fr

#include <LiquidCrystal.h>
#include <EEPROM.h>

LiquidCrystal lcd(8,9,10,11,12,13);
int NoPushTime = 200;
byte affPrin = 0;
byte menu = 1;
byte nbScreen;
int potVal;
byte STCP1 = 4;
byte STCP2 = 5;
byte SHCP = 3;
byte data = 2;
byte BP1 = A0;
byte BP2 = A1;
byte potPin = A3;
bool BPrel = 1;
int tabValOUT[] = {10,10,48,48,48,10,10,48};
byte valReg1_1;
byte valReg1_2;
byte valReg2_1;
byte valReg2_2;
byte nbPreset = 8;
byte preset = 1;
int menuVal[] = {0,0,0,0,0,0,0,0,0};
int menuValAct[] ={0,0,0,0,0,0,0,0,0};
byte tabOutSav[] = {0,0,0,0,0,0,0,0};
byte tabOutInd1;
byte tabOutInd2;
byte tabOut[4][8] = {
  {10,10,48,48,48,10,10,48},
  { 0, 0, 0, 0, 0, 0, 0, 0},
  { 2, 2,16,16,16, 2, 2,16},
  { 8, 8,32,32,32, 8, 8,32}
};

void setup() {
  Serial.begin(9600);
  lcd.begin(16,2);
  pinMode(STCP1,OUTPUT);
  pinMode(STCP2,OUTPUT);
  pinMode(SHCP,OUTPUT);
  pinMode(data,OUTPUT);
  digitalWrite(STCP1,HIGH);
  digitalWrite(STCP2,HIGH);
  loadPreset(0);
  MIDImaj();
}

//utiliser fonction map depuis position potentiomètre pour déterminer la ligne et la colonne pour la valeur MIDI

void menu0(){
  nbScreen = 2;
  if (menuVal[menu] != menuValAct[menu]){
    menuValAct[menu] = menuVal[menu];
    lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("!! RESET  ALL !!");
    lcd.setCursor(0,1);
    switch(menuVal[menu]){
      case 0:
      lcd.print(">            YES");
      break;
      case 1:
      lcd.print(">             NO");
      break;
    }
  }
  pot();
  if (BPrel == 1){
    if (analogRead(BP2) > 800 or analogRead(BP1) > 800){
      BPrel = 0;
      switch(menuVal[menu]){
        case 0:
        for (int i = 0; i < nbPreset; i++){
          erasePreset(i);
        }
        loadPreset(0);
        MIDImaj();
        lcd.clear();
        lcd.setCursor(0,0);
        lcd.print("    ERASING");
        lcd.setCursor(0,1);
        lcd.print("    FINISHED");
        delay(1000);
        break;
        case 1:
        lcd.clear();
        lcd.setCursor(0,0);
        lcd.print("    ERASING");
        lcd.setCursor(0,1);
        lcd.print("    CANCELLED");
        delay(1000);
        break;
      }
      menu = 2;
      affPrin = 1;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
  }
}

void menu1(){
  nbScreen = 1;
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print(" MIDI dispencer ");
  lcd.setCursor(0,1);
  lcd.print("DESPI_19    v3.1");
  delay(2000);
  menu = 2;
  affPrin = 1;
}

void menu2(){
  nbScreen = 1;
  if (affPrin == 1){
    lcd.clear();
    lcd.setCursor(0,0);
    lcd.print("1-");
    lcd.print(tabOutSav[0] + 1);
    lcd.print(" 2-");
    lcd.print(tabOutSav[1] + 1);
    lcd.print(" 3-");
    lcd.print(tabOutSav[2] + 1);
    lcd.print(" 4-");
    lcd.print(tabOutSav[3] + 1);
    lcd.setCursor(0,1);
    lcd.print("5-");
    lcd.print(tabOutSav[4] + 1);
    lcd.print(" 6-");
    lcd.print(tabOutSav[5] + 1);
    lcd.print(" 7-");
    lcd.print(tabOutSav[6] + 1);
    lcd.print(" 8-");
    lcd.print(tabOutSav[7] + 1);
    affPrin = 0;
  }
  if (BPrel == 1){
    if (analogRead(BP1) > 800){
      BPrel = 0;
      menu = 3;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
    else if (analogRead(BP2) > 800){
      BPrel = 0;
      menu = 6;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
  }
}

void menu3(){
  nbScreen = 1;
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("  MODIFICATION  ");
  delay(1000);
  menu = 4;
  menuVal[4] = 1000;
}

void menu4(){
  nbScreen = 8;
  if (menuVal[menu] != menuValAct[menu]){
    menuValAct[menu] = menuVal[menu];
    lcd.clear();
    lcd.setCursor(0,0);
    switch(menuVal[menu]){
      case 0:
      lcd.print(">  GP1 - OUT 1/2");
      lcd.setCursor(0,1);
      switch(tabOutSav[0]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
      case 1:
      lcd.print(">  GP2 - OUT 3/4");
      lcd.setCursor(0,1);
      switch(tabOutSav[1]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
      case 2:
      lcd.print(">  GP3 - OUT 5/6");
      lcd.setCursor(0,1);
      switch(tabOutSav[2]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
      case 3:
      lcd.print(">  GP4 - OUT 7/8");
      lcd.setCursor(0,1);
      switch(tabOutSav[3]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
      case 4:
      lcd.print("> GP5 - OUT 9/10");
      lcd.setCursor(0,1);
      switch(tabOutSav[4]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
      case 5:
      lcd.print(">GP6 - OUT 11/12");
      lcd.setCursor(0,1);
      switch(tabOutSav[5]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
      case 6:
      lcd.print(">GP7 - OUT 13/14");
      lcd.setCursor(0,1);
      switch(tabOutSav[6]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
      case 7:
      lcd.print(">GP8 - OUT 15/16");
      lcd.setCursor(0,1);
      switch(tabOutSav[7]){
        case 0:
        lcd.print("       ---> IN 1");
        break;
        case 1:
        lcd.print("       ---> IN 2");
        break;
        case 2:
        lcd.print("       ---> IN 3");
        break;
        case 3:
        lcd.print("       ---> IN 4");
        break;
      }
      break;
    }
  }
  pot();
  if (BPrel == 1){
    if (analogRead(BP2) > 800){
      BPrel = 0;
      menu = 2;
      affPrin = 1;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
    else if (analogRead(BP1) > 800){
      BPrel = 0;
      tabOutInd1 = menuVal[menu];
      menu = 5;
      menuVal[5] = 1000;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
  }
}

void menu5(){
  nbScreen = 4;
  if (menuVal[menu] != menuValAct[menu]){
    menuValAct[menu] = menuVal[menu];
    lcd.clear();
    lcd.setCursor(0,0);
    switch(menuVal[4]){
      case 0:
      lcd.print("   GP1 - OUT 1/2");
      break;
      case 1:
      lcd.print("   GP2 - OUT 3/4");
      break;
      case 2:
      lcd.print("   GP3 - OUT 5/6");
      break;
      case 3:
      lcd.print("   GP4 - OUT 7/8");
      break;
      case 4:
      lcd.print("  GP5 - OUT 9/10");
      break;
      case 5:
      lcd.print(" GP6 - OUT 11/12");
      break;
      case 6:
      lcd.print(" GP7 - OUT 13/14");
      break;
      case 7:
      lcd.print(" GP8 - OUT 15/16");
      break;
    }
    lcd.setCursor(0,1);
    switch(menuVal[menu]){
      case 0:
      lcd.print(">      ---> IN 1");
      break;
      case 1:
      lcd.print(">      ---> IN 2");
      break;
      case 2:
      lcd.print(">      ---> IN 3");
      break;
      case 3:
      lcd.print(">      ---> IN 4");
      break;
    }
  }
  pot();
  if (BPrel == 1){
    if (analogRead(BP2) > 800){
      BPrel = 0;
      menu = 4;
      menuVal[4] = 1000;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
    else if (analogRead(BP1) > 800){
      BPrel = 0;
      tabOutInd2 = menuVal[menu];
      tabOutSav[tabOutInd1] = tabOutInd2; 
      MIDImaj();
      menu = 2;
      affPrin = 1;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
  }
}

void menu6(){
  nbScreen =1;
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("    PRESETS     ");
  delay(1000);
  menu = 7;
  menuVal[7] = 1000;
}

void menu7(){
  nbScreen = 8;
  if (menuVal[menu] != menuValAct[menu]){
    menuValAct[menu] = menuVal[menu];
    lcd.clear();
    lcd.setCursor(0,0);
    switch(menuVal[menu]){
      case 0:
      lcd.print(">      PRESET *1");
      break;
      case 1:
      lcd.print(">      PRESET *2");
      break;
      case 2:
      lcd.print(">      PRESET *3");
      break;
      case 3:
      lcd.print(">      PRESET *4");
      break;
      case 4:
      lcd.print(">      PRESET *5");
      break;
      case 5:
      lcd.print(">      PRESET *6");
      break;
      case 6:
      lcd.print(">      PRESET *7");
      break;
      case 7:
      lcd.print(">      PRESET *8");
      break;
    }
  }
  pot();
  if (BPrel == 1){
    if (analogRead(BP2) > 800){
      BPrel = 0;
      menu = 2;
      affPrin = 1;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
    else if (analogRead(BP1) > 800){
      BPrel = 0;
      preset = menuVal[menu];
      menuVal[8] = 1000;
      menu = 8;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
  }
}

void menu8(){
  nbScreen = 3;
  if (menuVal[menu] != menuValAct[menu]){
    menuValAct[menu] = menuVal[menu];
    lcd.clear();
    lcd.setCursor(0,0);
    switch(preset){
      case 0:
      lcd.print("       PRESET *1");
      break;
      case 1:
      lcd.print("       PRESET *2");
      break;
      case 2:
      lcd.print("       PRESET *3");
      break;
      case 3:
      lcd.print("       PRESET *4");
      break;
      case 4:
      lcd.print("       PRESET *5");
      break;
      case 5:
      lcd.print("       PRESET *6");
      break;
      case 6:
      lcd.print("       PRESET *7");
      break;
      case 7:
      lcd.print("       PRESET *8");
      break;
    }
    lcd.setCursor(0,1);
    switch(menuVal[menu]){
      case 0:
      lcd.print(">           SAVE");
      break;
      case 1:
      lcd.print(">           LOAD");
      break;
      case 2:
      lcd.print(">          ERASE");
      break;
    }
  }
  pot();
  if (BPrel == 1){
    if (analogRead(BP2) > 800){
      BPrel = 0;
      menuVal[7] = 1000;
      menu = 7;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
    else if (analogRead(BP1) > 800){
      BPrel = 0;
      switch(menuVal[menu]){
        case 0:
        savePreset(preset);
        break;
        case 1:
        loadPreset(preset);
        MIDImaj();
        break;
        case 2:
        erasePreset(preset);
        loadPreset(preset);
        MIDImaj();
        break;
      }
      menu = 2;
      affPrin = 1;
      delay(NoPushTime); // à cause de la mauvaise qualité des boutons
    }
  }
}

void MIDImaj(){
  for (int i = 0; i < 8; i++){
    tabValOUT[i] = tabOut[tabOutSav[i]][i];
  }
  Serial.print(tabValOUT[0]);
  Serial.print("  ");
  Serial.print(tabValOUT[1]);
  Serial.print("  ");
  Serial.print(tabValOUT[2]);
  Serial.print("  ");
  Serial.print(tabValOUT[3]);
  Serial.print("  ");
  Serial.print(tabValOUT[4]);
  Serial.print("  ");
  Serial.print(tabValOUT[5]);
  Serial.print("  ");
  Serial.print(tabValOUT[6]);
  Serial.print("  ");
  Serial.println(tabValOUT[7]);
  valReg1_1 = tabValOUT[1] + tabValOUT[3]; //valOUT2 + valOUT4;
  valReg1_2 = tabValOUT[0] + tabValOUT[2]; //valOUT1 + valOUT3;
  valReg2_1 = tabValOUT[6] + tabValOUT[7]; //valOUT7 + valOUT8;
  valReg2_2 = tabValOUT[4] + tabValOUT[5]; //valOUT5 + valOUT6;
  digitalWrite(STCP1,LOW);
  shiftOut(data,SHCP,MSBFIRST,valReg1_1);
  shiftOut(data,SHCP,MSBFIRST,valReg1_2);
  digitalWrite(STCP1,HIGH);
  digitalWrite(STCP2,LOW);
  shiftOut(data,SHCP,MSBFIRST,valReg2_1);
  shiftOut(data,SHCP,MSBFIRST,valReg2_2);
  digitalWrite(STCP2,HIGH);
}

void pot(){
  potVal = analogRead(potPin);
  menuVal[menu] = map(potVal, 0, 1023, 0, nbScreen);
  if (menuVal[menu] == nbScreen){
    menuVal[menu] = nbScreen - 1;
  }
}

void savePreset(byte numPreset){
  for (int i = numPreset * 8; i < (numPreset + 1) * 8 ; i++){
    EEPROM.update(i, tabOutSav[i - (numPreset * 8)]);
  }
}

void loadPreset(byte numPreset){
  for (int i = numPreset * 8; i < (numPreset + 1) * 8; i++){
    tabOutSav[i - (numPreset * 8)] = EEPROM.read(i);
  }
}

void erasePreset(byte numPreset){
  for (int i = numPreset * 8; i < (numPreset + 1) * 8; i++){
    EEPROM.update(i, 0);
  }
}

void loop() {
  if (BPrel == 0){
    if (analogRead(BP1) < 800 and analogRead(BP2) < 800){
      BPrel = 1;
    }
  }
  if (analogRead(BP1) > 800 and analogRead(BP2) > 800){
    BPrel = 0;
    menuVal[0] = 1000;
    menu = 0;
  }
  switch(menu){
    case 0:
    menu0();
    break;
    case 1:
    menu1();
    break;
    case 2:
    menu2();
    break;
    case 3:
    menu3();
    break;
    case 4:
    menu4();
    break;
    case 5:
    menu5();
    break;
    case 6:
    menu6();
    break;
    case 7:
    menu7();
    break;
    case 8:
    menu8();
    break;
  }
}
