//by DESPI, 2019, seq3x8, v2.1
//static-waves.fr

byte reg1 = 48;
byte reg2 = 50;
byte reg3 = 52;
byte oscOn = 12;
byte osc = 13;
byte levRandom = 36;
byte BP[10] = {23,25,27,29,31,33,35,37,34,32}; //1-8: BP pas (1-8), 9: BP on, 10: BP off
byte BPBloq[10] = {0,0,0,0,0,0,0,0,0,0}; //1-8: BP pas (1-8), 9: BP on, 10: BP off
byte JackIn[10] = {39,41,43,45,47,49,51,53,24,28}; //1-8: Jack pas (1-8), 9: Jack on, 10:Jack off
byte JackInBloq[10] = {0,0,0,0,0,0,0,0,0,0}; //1-8: Jack pas (1-8), 9: Jack on, 10:Jack off
char com[8] = {A7,A6,A5,A4,A3,A2,A1,A0};
byte valCom[8];
byte numPas = 1;
byte oscRun = 0;
byte oscOffCom = 0;
byte bloqChangePas = 0;
byte sautCont = 0;

void setup() {
  Serial.begin(9600);
  pinMode(reg1,OUTPUT);
  pinMode(reg2,OUTPUT);
  pinMode(reg3,OUTPUT);
  pinMode(oscOn,OUTPUT);
  pinMode(osc,INPUT);
  pinMode(levRandom,INPUT);
  for(int i = 0; i < 10; i++){
    pinMode(BP[i],INPUT);
    pinMode(JackIn[i],INPUT);
  }
}

void loop() {
  oscil();
  readAllPas();
  changePas();
  if(digitalRead(osc) == HIGH){
    if(bloqChangePas == 0){
      bloqChangePas = 1;
      followAct();
    }
  }
  else{
    bloqChangePas = 0;
    if(oscOffCom == 1){
      oscOffCom = 0;
      oscRun = LOW;
    }
  }
}

void oscil() {
  digitalWrite(oscOn,oscRun);
  if(digitalRead(BP[8]) == HIGH){
    if(BPBloq[8] == 0){
      oscRun = HIGH;
      BPBloq[8] = 1;
    }
  }
  else{
    BPBloq[8] = 0;
  }
  if(digitalRead(JackIn[8]) == HIGH){
    if(JackInBloq[8] == 0){
      oscRun = HIGH;
      JackInBloq[8] = 1;
    }
  }
  else{
    JackInBloq[8] = 0;
  }
  if(digitalRead(BP[9]) == HIGH){
    if(BPBloq[9] == 0){
      oscRun = LOW;
      BPBloq[9] = 1;
    }
  }
  else{
    BPBloq[9] = 0;
  }
  if(digitalRead(JackIn[9]) == HIGH){
    if(JackInBloq[9] == 0){
      oscRun = LOW;
      JackInBloq[9] = 1;
    }
  }
  else{
    JackInBloq[9] = 0;
  }
}

void followAct() {
  switch(valCom[numPas - 1]){
    case 0:
    if(digitalRead(levRandom) == HIGH){
      numPas = random(1,9);
    }
    else{
      numPas++;
      depass();
      skip();
    }
    break;
    case 1:
    numPas = random(1,9);
    break;
    case 2:
    if(digitalRead(levRandom) == HIGH){
      numPas = random(1,9);
    }
    else{
      numPas++;
      depass();
      skip();
    }
    break;
    case 3:
    numPas = 1;
    skip();
    break;
  }
  if(valCom[numPas - 1] == 5){
    oscOffCom = 1;
  }
}

void skip() {
  if(valCom[numPas - 1] == 0){
    numPas++;
    sautCont = 1;
    depass();
    for(byte i = 0; i < 6; i++){
      if(valCom[numPas - 1] == 0 and sautCont == 1){
        numPas++;
        depass();
      }
      else{
        sautCont = 0;
      }
    }
  }
}

void readAllPas() {
  for(int i = 0; i < 8; i++){
    if(digitalRead(BP[i]) == HIGH){
      if(BPBloq[i] == 0){
        numPas = i + 1;
        BPBloq[i] = 1;
      }
    }
    else{
      BPBloq[i] = 0;
    }
     if(digitalRead(JackIn[i]) == HIGH){
      if(JackInBloq[i] == 0){
        numPas = i + 1;
        JackInBloq[i] = 1;
      }
    }
    else{
      JackInBloq[i] = 0;
    }
    valCom[i] = map(analogRead(com[i]), 0, 1023, 0, 5);
  }
}

void changePas() {
  switch(numPas){
    case 1:
    digitalWrite(reg1,HIGH);
    digitalWrite(reg2,HIGH);
    digitalWrite(reg3,HIGH);
    break;
    case 2:
    digitalWrite(reg1,HIGH);
    digitalWrite(reg2,HIGH);
    digitalWrite(reg3,LOW);
    break;
    case 3:
    digitalWrite(reg1,HIGH);
    digitalWrite(reg2,LOW);
    digitalWrite(reg3,HIGH);
    break;
    case 4:
    digitalWrite(reg1,HIGH);
    digitalWrite(reg2,LOW);
    digitalWrite(reg3,LOW);
    break;
    case 5:
    digitalWrite(reg1,LOW);
    digitalWrite(reg2,HIGH);
    digitalWrite(reg3,HIGH);
    break;
    case 6:
    digitalWrite(reg1,LOW);
    digitalWrite(reg2,HIGH);
    digitalWrite(reg3,LOW);
    break;
    case 7:
    digitalWrite(reg1,LOW);
    digitalWrite(reg2,LOW);
    digitalWrite(reg3,HIGH);
    break;
    case 8:
    digitalWrite(reg1,LOW);
    digitalWrite(reg2,LOW);
    digitalWrite(reg3,LOW);
    break;
  }
}

void depass() {
  if(numPas == 9){
    numPas = 1;
  }
}
